#!/bin/bash

if [[ $# -ne 5 ]]; then
	echo "Arguments: rdf3xBinFolder rdf3xDb queryFolder timeout outLabel"
	exit 2
fi

timeout=$(($4 * 1000))

echo "Using rdf3x bin $1"
echo "Using rdf3x db $2"
echo "Using query folder $3"
echo "Using timeout $4 s $timeout ms"

echo "Opening query folder $3"
for file in $3/*.txt; do
	if [[ ! -e $file ]]; then
		echo "No query file with suffix .txt found in folder $3"
		continue
	fi
	queryName=$(basename $file)
	__dir="$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)"
	echo "Opening $file"
	echo "Benchmarking $queryName"
	echo "Writing results to $3/output/${queryName%.*}/$5.txt"
	mkdir -p $3/output/
	mkdir -p $3/output/${queryName%.*}
	python ${__dir}/benchmark-rdf3x.py $3/$queryName $1 $2 $4 > $3/output/${queryName%.*}/$5.txt
	echo "[done]"
done

kill $!